package gov.va.vinci.dart.db.impl;

import java.util.List;

import javax.persistence.Query;

import gov.va.vinci.dart.biz.OperationalStudy;
import gov.va.vinci.dart.db.OperationalStudyDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

public class OperationalStudyDAOImpl extends HibernateDAO implements OperationalStudyDAO {

	@Override
	public OperationalStudy findById(final int activityId) {
		Query q = createQuery("from OperationalStudy where id=:aid");
		q.setParameter("aid", activityId);
		return (OperationalStudy)q.getSingleResult();
	}

	@Override
	public OperationalStudy findByShortName(final String name) {
		
		Query query = createQuery("from OperationalStudy where name like :rsid");
		query.setParameter("rsid", name);
		return (OperationalStudy)query.getSingleResult();
	}

	@Override
	public void save(final OperationalStudy activity) {
		if (activity == null) {
			throw new IllegalArgumentException();
		}
		
		HibernateDAO.save(activity);
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<OperationalStudy> listAll() {
		Query query = createQuery("from OperationalStudy");
		return (List<OperationalStudy>)query.getResultList();
	}

}
